/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.client;

import java.io.File;
import java.io.IOException;
import java.text.ParseException;
import java.util.HashMap;
import java.util.Map;
import org.netbeans.modules.subversion.Subversion;
import org.netbeans.modules.subversion.client.SvnClient;
import org.netbeans.modules.subversion.client.parser.ParserSvnInfo;
import org.netbeans.modules.subversion.client.parser.SvnWcUtils;
import org.netbeans.modules.subversion.config.KVFile;
import org.netbeans.modules.subversion.util.SvnUtils;
import org.tigris.subversion.svnclientadapter.ISVNInfo;
import org.tigris.subversion.svnclientadapter.ISVNProperty;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNRevision;

public final class PropertiesClient {
    private final File file;

    public PropertiesClient(File file) {
        assert (file != null);
        this.file = file;
    }

    public Map<String, byte[]> getBaseProperties(boolean contactServer) throws IOException {
        if (PropertiesClient.hasOldMetadata(this.file)) {
            File store;
            try {
                store = this.getPropertyFile(true);
            }
            catch (SVNClientException ex) {
                throw new IOException(ex.getMessage());
            }
            if (store != null && store.isFile()) {
                KVFile kv = new KVFile(store);
                return kv.getNormalizedMap();
            }
            return new HashMap<String, byte[]>();
        }
        HashMap<String, byte[]> map = new HashMap<String, byte[]>();
        try {
            if (contactServer) {
                ISVNInfo info;
                SvnClient client = Subversion.getInstance().getClient(this.file);
                if (client != null && (info = SvnUtils.getInfoFromWorkingCopy(client, this.file)) != null && (info.getUrl() != null || info.getCopyUrl() != null) && info.getRevision() != null && info.getRevision().getNumber() > -1L) {
                    ISVNProperty[] props;
                    for (ISVNProperty prop : props = client.getProperties(info.getCopyUrl() == null ? info.getUrl() : info.getCopyUrl(), SVNRevision.getRevision((String)info.getRevision().toString()), SVNRevision.getRevision((String)info.getRevision().toString()), false)) {
                        map.put(prop.getName(), prop.getData());
                    }
                }
            } else {
                return this.getProperties();
            }
            return map;
        }
        catch (SVNClientException ex) {
            return map;
        }
        catch (ParseException ex) {
            return map;
        }
    }

    public Map<String, byte[]> getProperties() throws IOException {
        if (PropertiesClient.hasOldMetadata(this.file)) {
            File store;
            try {
                store = this.getPropertyFile(false);
                if (store == null) {
                    store = this.getPropertyFile(true);
                }
            }
            catch (SVNClientException ex) {
                throw new IOException(ex.getMessage());
            }
            if (store != null && store.isFile()) {
                KVFile kv = new KVFile(store);
                return kv.getNormalizedMap();
            }
            return new HashMap<String, byte[]>();
        }
        try {
            SvnClient client = Subversion.getInstance().getClient(false);
            HashMap<String, byte[]> map = new HashMap<String, byte[]>();
            if (client != null) {
                ISVNProperty[] props;
                for (ISVNProperty prop : props = client.getProperties(this.file)) {
                    map.put(prop.getName(), prop.getData());
                }
            }
            return map;
        }
        catch (SVNClientException ex) {
            return new HashMap<String, byte[]>();
        }
    }

    private File getPropertyFile(boolean base) throws SVNClientException {
        SvnClient client = Subversion.getInstance().getClient(false);
        ISVNInfo info = null;
        info = SvnUtils.getInfoFromWorkingCopy(client, this.file);
        if (info instanceof ParserSvnInfo) {
            if (base) {
                return ((ParserSvnInfo)info).getBasePropertyFile();
            }
            return ((ParserSvnInfo)info).getPropertyFile();
        }
        return SvnWcUtils.getPropertiesFile(this.file, base);
    }

    public Map getProperties(int revision) throws IOException {
        throw new UnsupportedOperationException();
    }

    public static boolean hasOldMetadata(File file) {
        File parent;
        return new File(file, SvnUtils.SVN_ENTRIES_DIR).canRead() || (parent = file.getParentFile()) != null && new File(parent, SvnUtils.SVN_ENTRIES_DIR).canRead() && !new File(parent, SvnUtils.SVN_WC_DB).exists();
    }
}

